<?php
/**
 * Veidotājs: Roberts Blite
 * Mērķis: Šis PHP skripts nosaka un atgriež lietotāja lomu, pamatojoties uz sesijas datiem.
 * Apraksts: Skripts pārbauda, vai lietotājs ir autentificēts, un, ja ir,
 *           atgriež viņa lomu JSON formātā. Ja lietotājs nav autorizēts,
 *           tiek nosūtīts kļūdas ziņojums.
 */

session_start(); // Sāk sesiju, lai piekļūtu saglabātajiem lietotāja datiem

header('Content-Type: application/json'); // Iestata atbildes tipu kā JSON

// Pārbauda, vai lietotājs ir autentificēts (vai sesijā ir `user_id` un `work_position`)
if (!isset($_SESSION['user_id']) || !isset($_SESSION['work_position'])) {
    echo json_encode(["error" => "Neautorizēta piekļuve."]); // Atgriež kļūdu, ja lietotājs nav pierakstījies
    exit;
}

// Ja lietotājs ir autentificēts, atgriež viņa lomu JSON formātā
echo json_encode(["role" => $_SESSION['work_position"]]);
?>